% Intro to MATLAB class 2 A few examples from the lecture in class for
% reference. This class we covered some ways to remove certain parts of
% data to work with and basic if, for, and while statements.

% Written by: Alex of Lunatic Labs
% https://loonylabs.org/2021/06/20/intro-to-matlab-part-2/
% 2021 June 17

%% Ways to work with your data

% There are far too many ways to perform operations in MATLAB for me to
% create a comprehensive guide. Instead I will cover the logic behind how
% you take data from different variable types so you can perform some
% operation on it.

% The N-dimensional matrix example

M = randi([0,10], [4,4,6,10]);

% Here we have a matrix M that is 4 rows by 4 columns by 6 layers and 10
% blocks (there's no good terminology for the name of the fourth dimension)
% MATLAB makes it easy to take out data from matrices as long as you
% remember the order which is: M(row,column,layers,blocks)

% For completeness, randi is a pseudo-random number generator function in
% MATLAB so randi([0, 10] ... means that I want it to select whole numbers
% from 0 to 10 and the… , [4,4,6,10]); part is my matrix dimensions I want
% it to fill.

% If I want the first row of the second layer and third block, we can call
% that by using the following:

VRow = M(1,:,2,3);

% The : operator above means that I want all the values from that
% dimension, in this case I want all the columns of the first row so : is
% used. The returned values are a row vector V from that four dimensional
% matrix. If we want the first column from the same layer and block, we can
% use the : operator in the first position like so:

VCol = M(:,1,2,3);

% Feel free to manually check that this is working correctly by opening the
% 4-D matrix M and finding the correct location!

% We can use multiple : operators though, so if we wanted all the rows and
% columns of the first layer and second block of our matrix, we can do that
% too:

MMat = M(:,:,1,2);

% We can even remove a three-dimensional chunk of this data by using a
% third : in the third or fourth positions. Although using it in the fourth
% position would create a 4-D matrix with the third dimension having length
% 1 which is weird, but that's higher dimensional math for you. We can fix
% that using the squeeze function, but that is beyond the scope of this
% intro.

%% Cells

% Thankfully cells work the same exact way, but instead of using the ()
% symbols we use the {} symbols. So, let's create a cell array and look at
% how data works there.

C = mat2cell(randi(50,20,10), [2,6,12],10)';

% C1 is a cell array consisting of 3 matrices of different sizes. As always
% for completeness mat2cell turns a matrix into a cell, so that's what
% we've done here to create 3 different cells with matrices that are 2
% rows, 6 rows, and 12 rows x 10 columns. The ' at the end inverted this
% from column to row.

% Now we can pull out a cell easy enough by using the same ordering as
% above in this case: C{row, column} Please note, when there is only 1 row,
% or 1 column MATLAB will allow you to use just one number such as C{2} to
% grab the second entry, this is not a good practice because MATLAB will
% also let you do this with two dimensional cells and the result can be
% unpredictable so always, ALWAYS enter both the row and column you are
% working with. You have been warned!

% Let's take out the second matrix from this cell array

M2 = C{1,2};

% Say I want all the values of the third row from cell 2 instead of the
% whole matrix, that operation is:

VC = C{1,2}(3,:);

%% Checking size for validation

% You'll probably forget the order of the data you want, but you'll know
% the size you expect when you run a command. For example, if I have data
% that are 2 rows by 10 columns, and I want all the second row, I know it
% will be 10 values long. In MATLAB there are two ways to check the
% dimensions of the data you are working with the size and length commands.

% Length

length(VC)

% This returns the length of our vector from cell C in the above example.
% The second cell in that cell array was 6 rows by 10 columns so we expect
% that if we really took the row to have a variable with length 10.

% Size

size(M)

% As I've learned to use MATLAB, I've found that I prefer size over length.
% Size gives you all the dimensions of your variable in this case M is size
% 4x4x6x10. So why do I prefer the size command over the length command?
% Well length returns the length of the biggest dimension so when working
% with data you may have a matrix that changes in size and length may give
% you a different result than the one you want. Say I want the length of
% the layers of matrix M. Since layers are our third dimension, we can do
% that in the size command by:

size(M,3)

% Where length M will only return the longest dimension, in this case the
% length of the fourth dimension (10), check it out:

length(M)

% So, when working with data I will often know the expected size of a
% dimension and size can check that specific dimension, where length
% doesn't have that functionality making size more robust! In short, when
% writing code, you should use size and specify the dimension instead of
% trusting length will always return the answer you're looking for.

%% Structures

% Working with structures is very similar so instead of showing how to pull
% out data from a structure, let's look at how we can use a structure to
% create a plot using a single variable in our workspace

data.x = linspace(0,2*pi);
data.y = sin(data.x);
data.title = 'y = sin(x)';

% Now we've created some data for our x-coordinates, our y-coordinates and
% we have a title for our plot. A simple plot can be made with just two
% lines of code:

plot(data.x,data.y)
title(data.title)

% Of course, that is an "ugly" plot and there are better ways to create
% plots, but this is just an example. Structures are very useful for
% keeping your workspace clean because if you have hundreds of variables it
% can be hard to keep track of them all.


%% Conditionals and loops

% Sometimes when programing you'll need to do a specific operation
% repeatedly. Often, we run into this in our work when we're using data
% from multiple subjects and want to keep the subjects separate. In that
% case we can use a for statement to do things for a specific number of
% times. Here's a simple example.

% Let's count from 1 to 10 in increments of 10 using a for statement.

for i = 1:10
    
    fprintf('\n We are on loop number %d \n', i)
    pause(0.75)
    
end

% fprintf is useful when you want a statement to be printed in the command
% line. I use it often when run through several operations and want some
% confirmation that the step is running properly or when something is
% completed. pause does just that, pauses the for loop for 0.75 seconds. i
% is the variable we are using for our loop counter. you can use anything
% you want if you remember. I tend to use i, ii, iii, etc. because it's
% easy for me to not use that in a different context. To create a new line
% when printing use \n otherwise it will print all on the same line and the
% command line symbol (>>) will appear at the end of the sentance. 

%% Introducing the while statement
% Now let's look at a simple example of a while loop. While loops will run
% until a specific condition or conditions are met. We'll look at a while
% loop using a single condition, but they can get complex, you could need
% to meet two conditions using an and, & , or you may have two conditions
% and the while loop only needs to meet one of those conditions and we do
% that using a or | we can go over those another time though. Let's look at
% an example here.

% The simplest way to do this is to use the for loop again. This time let's
% add a while statement inside

ii = 1;

for i = 1:10
    
    fprintf('\n We are on loop number %d \n', i)
    pause(0.75)
    
    while ii < 4
        
        fprintf('\n We print this message 3 times for fun... \n')
        pause(0.75)
        ii = ii+1;
    end
    
    ii = 1;
    
end

% In this case I used a while statement to print something else inside.
% Notice I created a new variable ii to keep track of the second variable.
% Also notice that our while statement ran 3 times because a while is just
% a for loop that needs to meet a certain condition before it finishes
% running. This example isn't great because we created an arbitrary
% condition for it to meet, but while statements are very useful! This
% example is simply to show how it works. You'll know you need a while
% statement when you're writing code because you'll need to loop through an
% operation until a condition is met.


%% We also need to look at the if, else we have nothing!

% While statements are great, but they loop. What if you want to run a bit
% of code a single time when your condition is met? In that case we have an
% if statement. We can have several different conditions in a single
% statement or we can do several different things depending on the
% conditions that we set using elseif statements. The third option is to
% set a catch all statement using else, and this is a very powerful tool.
% Let's look at our previous example, but this time we'll use if, elseif,
% and else statements.

for i = 1:15
    
    fprintf('\n We are on loop number %d \n', i)
    pause(0.75)
    
    if i < 5
        
        fprintf('\n Still less than 5 ... \n')
        pause(0.75)
        
    elseif i >= 10
        
        fprintf('\n Oh we hit 10 or more! \n')
        pause(0.75)
        
    else
        
        fprintf('\n We didn''t meet any of our conditions!')
        
    end
end

% As before these aren't great examples, but they show how the logic behind
% them works and that's what I want you to take away from this course, is
% how the logic is applied. 

% Helpful hint: If you create an infinite loop by mistake, control + c will
% stop the code from running, this is useful for other things too like code
% that may take a long time to run, but you incorrectly entered something
% into the function.
